/*
 * Decompiled with CFR 0.152.
 */
package apicore.message;

import apicore.message.AuthChallengeLTV;
import apicore.message.AuthRequestLTV;
import apicore.message.AuthResponseLTV;
import apicore.message.AuthStatusLTV;
import apicore.message.BooleanValue;
import apicore.message.DisconnectLTV;
import apicore.message.IPCErrorLTV;
import apicore.message.IPCEventLTV;
import apicore.message.IPCResponseLTV;
import apicore.message.KeepAliveLTV;
import apicore.message.LTV;
import apicore.message.LTVParsingError;
import apicore.message.StringValue;
import apicore.message.UUID;
import apicore.mu.MUConInMessage;
import apicore.mu.MUConOutMessage;
import apicore.mu.MULinkUpdMessage;
import apicore.mu.MUNameUpdMessage;
import apicore.mu.MUNegotiationMessage;
import apicore.mu.MUPDUMessage;
import apicore.mu.MUPortAdvMessage;
import apicore.mu.MUSaveNetReqMessage;
import apicore.ptmp.EncodedBuffer;
import apicore.util.Logger;
import apicore.util.Pair;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LTVFactory {
    public LTV createLTV(EncodedBuffer encodedBuffer) {
        LTV lTV = null;
        if (encodedBuffer.remaining() <= 0) {
            return null;
        }
        int n = encodedBuffer.getInt();
        switch (n) {
            case 0: {
                break;
            }
            case 2: {
                String string = encodedBuffer.getString();
                lTV = new AuthRequestLTV(new StringValue(string));
                break;
            }
            case 3: {
                String string = encodedBuffer.getString();
                lTV = new AuthChallengeLTV(new StringValue(string));
                break;
            }
            case 4: {
                String string = encodedBuffer.getString();
                String string2 = encodedBuffer.getString();
                lTV = new AuthResponseLTV(string, string2);
                break;
            }
            case 5: {
                boolean bl = encodedBuffer.getBool();
                lTV = new AuthStatusLTV(new BooleanValue(bl));
                break;
            }
            case 6: {
                lTV = new KeepAliveLTV();
                break;
            }
            case 100: {
                lTV = this.parseIPCMessageLTV(encodedBuffer);
                break;
            }
            case 102: {
                lTV = this.parseIPCResponseLTV(encodedBuffer);
                break;
            }
            case 101: {
                lTV = this.parseIPCErrorLTV(encodedBuffer);
                break;
            }
            case 103: {
                lTV = this.parseIPCEventLTV(encodedBuffer);
                break;
            }
            case 104: {
                lTV = this.parseIPCEventSubscriptionLTV(encodedBuffer);
                break;
            }
            case 7: {
                lTV = new DisconnectLTV();
                break;
            }
            case 200: {
                lTV = MUNegotiationMessage.getMessage(encodedBuffer);
                break;
            }
            case 201: {
                lTV = MUNegotiationMessage.getMessage(encodedBuffer);
                break;
            }
            case 202: {
                lTV = MUPortAdvMessage.getMessage(encodedBuffer);
                break;
            }
            case 203: {
                lTV = MULinkUpdMessage.getMessage(encodedBuffer);
                break;
            }
            case 204: {
                lTV = MULinkUpdMessage.getMessage(encodedBuffer);
                break;
            }
            case 205: {
                lTV = MUPDUMessage.getMessage(encodedBuffer);
                break;
            }
            case 206: {
                lTV = MUSaveNetReqMessage.getMessage(encodedBuffer);
                break;
            }
            case 207: {
                lTV = MUSaveNetReqMessage.getMessage(encodedBuffer);
                break;
            }
            case 208: {
                lTV = MUConInMessage.getMessage(encodedBuffer);
                break;
            }
            case 209: {
                lTV = MUConOutMessage.getMessage(encodedBuffer);
                break;
            }
            case 210: {
                lTV = MUNameUpdMessage.getMessage(encodedBuffer);
                break;
            }
            default: {
                String string = new String(encodedBuffer.getRawBytes());
                Logger.error("Unrecognized message type: " + n + "\n\tMessage Body = " + string.replace('\u0000', '_'));
            }
        }
        if (lTV != null) {
            lTV.setType(n);
        }
        return lTV;
    }

    public LTV parseIPCEventSubscriptionLTV(EncodedBuffer encodedBuffer) {
        return null;
    }

    public LTV parseIPCMessageLTV(EncodedBuffer encodedBuffer) {
        return null;
    }

    public LTV parseIPCResponseLTV(EncodedBuffer encodedBuffer) {
        int n = encodedBuffer.getInt();
        IPCResponseLTV iPCResponseLTV = new IPCResponseLTV(n);
        if (encodedBuffer.remaining() == 0) {
            return iPCResponseLTV;
        }
        iPCResponseLTV.setValue(this.getResponseData(encodedBuffer));
        return iPCResponseLTV;
    }

    public LTV parseIPCErrorLTV(EncodedBuffer encodedBuffer) {
        int n = encodedBuffer.getInt();
        String string = encodedBuffer.getString();
        String string2 = encodedBuffer.getString();
        return new IPCErrorLTV(n, string, string2);
    }

    public LTV parseIPCEventLTV(EncodedBuffer encodedBuffer) {
        int n = encodedBuffer.getInt();
        String string = encodedBuffer.getString();
        UUID uUID = encodedBuffer.getUUID();
        String string2 = encodedBuffer.getString();
        List<Object> list = this.getParameterList(encodedBuffer);
        return new IPCEventLTV(string, uUID, string2, list);
    }

    public Object getResponseData(EncodedBuffer encodedBuffer) {
        byte by = encodedBuffer.getByte();
        return this.getResponseData(encodedBuffer, by);
    }

    public Object getResponseData(EncodedBuffer encodedBuffer, byte by) {
        return this.getResponseData(encodedBuffer, by, false);
    }

    public Object getResponseData(EncodedBuffer encodedBuffer, byte by, boolean bl) {
        switch (by) {
            case 2: {
                return new Boolean(encodedBuffer.getBool());
            }
            case 1: {
                return new Byte(bl ? encodedBuffer.getByteRaw() : encodedBuffer.getByte());
            }
            case 16: {
                return this.createIPCResponseObject(encodedBuffer);
            }
            case 7: {
                return new Double(encodedBuffer.getDouble());
            }
            case 6: {
                return new Float(encodedBuffer.getFloat());
            }
            case 4: {
                return new Integer(encodedBuffer.getInt());
            }
            case 10: {
                return encodedBuffer.getIPAddress();
            }
            case 11: {
                return encodedBuffer.getIPV6Address();
            }
            case 5: {
                return new Long(encodedBuffer.getLong());
            }
            case 12: {
                return encodedBuffer.getMACAddress();
            }
            case 14: {
                return this.getPairData(encodedBuffer);
            }
            case 3: {
                return new Short(encodedBuffer.getShort());
            }
            case 8: 
            case 9: {
                return encodedBuffer.getString();
            }
            case 13: {
                return encodedBuffer.getUUID();
            }
            case 15: {
                return this.getVectorData(encodedBuffer);
            }
            case 0: {
                return null;
            }
        }
        throw new LTVParsingError("Unhandled type for IPCReturnLTV: " + by);
    }

    protected Object createIPCResponseObject(EncodedBuffer encodedBuffer) {
        throw new Error("Unable to handle IPC Data Type returns in LTVFactory; you must use a subclass instead.");
    }

    public Pair<Object, Object> getPairData(EncodedBuffer encodedBuffer) {
        Object object = this.getResponseData(encodedBuffer);
        Object object2 = this.getResponseData(encodedBuffer);
        return new Pair<Object, Object>(object, object2);
    }

    public List<Object> getVectorData(EncodedBuffer encodedBuffer) {
        byte by = encodedBuffer.getByte();
        int n = encodedBuffer.getInt();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getResponseData(encodedBuffer, by, true));
        }
        return arrayList;
    }

    public List<Object> getParameterList(EncodedBuffer encodedBuffer) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = this.getResponseData(encodedBuffer);
        while (object != null) {
            arrayList.add(object);
            object = this.getResponseData(encodedBuffer);
        }
        return arrayList;
    }
}

